 ; Ŀ
 ;   Ssca - rescale all selected blocks.                                   
 ;   Copyright 1994, 2004 by Rocket Software Ltd.                          
 ;                                                                         
 ; 
 (DEFUN C:SSCA (/ ss enam entt scal inss len num)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Get blocks to scale.                                                  
 ; 
  (setq ss (ssget '((0 . "INSERT"))))
 ; Ŀ
 ;   Get new scale.                                                        
 ; 
  (if (/= (type newsc) 'REAL) (setq newsc 1))
  (setq newscp (getreal (strcat "\nNew scale <" (rtos newsc 2 2) ">: ")))
  (if newscp (setq newsc newscp))
 ; Ŀ
 ;   Now scale them all.                                                   
 ; 
  (if ss (setq len (sslength ss)))
  (setq num 0)
  (while (and ss (setq enam (ssname ss 0)))
         (setq entt (entget enam))
         (setq scal (abs (cdr (assoc 41 entt))))
         (if (/= scal newsc)
             (progn
                  (setq num (1+ num))
                  (setq inss (cdr (assoc 10 entt)))
                  (command "scale" enam "" inss (/ newsc scal))))
         (ssdel enam ss))
 ; Ŀ
 ;   Debrief the operative.                                                
 ; 
  (if len
     (prompt (strcat "\n" (itoa len) " insert" (if (= num 1) "" "s") " found"))
     (write-line "No blocks found."))
  (if (> num 0)
     (prompt (strcat ", " (itoa num) " rescaled."))
     (if len (prompt ".")))
  (command "undo" "end")
 (princ))